//2-19-01 compile with Neuron image version 7 and MIP version 2.3
#pragma micro_interface
#pragma idempotent_duplicate_on

// Select explicit addressing on or off with this pragma.
#pragma explicit_addressing_on

// Select NEURON CHIP (on) or host (off) NV selection.
#pragma netvar_processing_off

#pragma set_id_string                   "LM104_I7"

// Modify the following pragmas to set buffer sizes and counts.
#pragma app_buf_out_count               95
#pragma app_buf_out_priority_count      5
#pragma app_buf_in_count                95
#pragma app_buf_out_size                66
#pragma app_buf_in_size                 66
#pragma net_buf_out_size                66
#pragma net_buf_in_size                 66
#pragma net_buf_out_priority_count      5
#pragma net_buf_in_count                23
#pragma net_buf_out_count               23
#pragma receive_trans_count             16

// Modify this declaration to suit your hardware interface.
IO_0 parallel slave p_bus;

// The argument <irqp> is a pointer to the Interrupt Callback function.
//
// The argument <throttle> will yield about 350 microseconds
// of delay per count. A value of one yields no throttle.
extern void mip_p50_interface(void (*irqp)(void), unsigned long throttle);

// Define the interrupt callback function. This function should
// restrict its activities to I/O oriented actions.
void irq_callback(void) {
    *(unsigned short *) (0xE000) = 0x01;
}

when (reset) {
    // This starts up the Neuron MIP firmware and never comes back
    mip_p50_interface(irq_callback, 1UL);
}
