/*****************************************************************
    Filename: MIP_TYPS.H
    Copyright 1992, 1993 (C) Echelon Corp. All rights reserved
    %W% %G% %U%
    modified 10/10/94 by Don M. Scofield
                      for LM-104
*****************************************************************/
#ifndef EXT
#define EXT extern
#define INIT(x)
#else
#define INIT(x) = x
#endif

typedef unsigned char byte;
typedef enum {
    FALSE = 0,
    TRUE
} BOOLEAN;

/* mip_state values: */
typedef enum {
    MIP_IDLE,
    MIP_ACK_WAIT,
    MIP_ACK_OKAY
} MipState;

// Interface States:
typedef enum {
    IStateIdle1,	// Host owns token
    IStateDownNull,	// NULL xfer is going down
    IStateDownXfer,     // Non-NULL data is going down
    IStateIdle2,	// MIP owns token
    IStateUpXferA,      // First bytes coming up
    IStateUpXferB       // Rest of bytes coming up
} IState;

/* NEURON parallel port command data values: */
#define CMD_RESYNC	0x5A
#define CMD_ACKSYNC	0x07
#define CMD_NULL	0x00
#define CMD_XFER	0x01

// Hardware Interface I/O Ports:
// The registers io_port_num and io_port_num provide direct
// access to the MIP's parallel port and will pulse the MIP's CS
// input when read/written.
// The four bits of status appear in io_port_num+1.
// and io_port_num+1 will eather reset the MIP or clear the status
// flags (RESET, DMA_END, and UL_INT).
// On the LM-104, DMA is not supported so the DMA_END bit is ignored

//#define RISR_DMA_END		0x02    

#define RISR_RESET		0x01
#define RISR_HS			0x02
#define RISR_UL_INT		0x04	

#define WCNTL_RESET		0x01	// For h.w. reset of the MIP
#define WCNTL_CLR_FLGS		0x06	// For clearing status flags
#define WCNTL_CLR_ALL		0x07	// For clearing status and 
					// resetting MIP

#define PPORT1			0x1E0
#define PPORT2			0x300
#define PPORT3			0x310
#define PPORT4			0x320

#define PIO_DATA_MAX	254+1	// bumped to allow EOM and end.
// The whole NEURON PMIP transfer structure, including link pointer:
typedef struct PioXferWhole_s {
    struct PioXferWhole_s *next;
    byte busy;			// filled, to be processed.
    byte cmd_xfer;		// for downlink, fill in with CMD_XFER
    byte xfer_length;		// length includes mip_cmd, xfer_data.
    byte mip_cmd;
    byte xfer_data[PIO_DATA_MAX];
} PioXferWhole;

/* The message structure as passed to the driver: */
typedef struct {
    byte mip_cmd;
    byte xfer_length;
    byte net[3+11+32];
} NetMsg;

// DMA Register Definitions
#define DMA0_BASE	0x00	// Address of dma controller (chan 0-3)
#define DMA1_BASE	0xC0	// Address of dma controller (chan 4-7)
#define DMA_MASK	0x04
#define DMA_MODE_IN	0x44	// single xfer, no auto init, I/O to MEM
#define DMA_MODE_OUT	0x48	// single xfer, no auto init, MEM to I/O

#define DMA_MASK_OFS	10	// offset of MASK register
#define DMA_MODE_OFS	11	// offset of MODE register

// PIC Hardware:
#define PIC_1			0x20
#define PIC_2			0xA0

#define EOI_CODE		0x60
#define NS_EOI			0x20
#define RISR_CODE		0x0B

#define EOI_OFFS		0x00
#define IMR_OFFS		0x01
#define OCW3_OFFS		0x00

#define DOS_TICK		0x1C


/* Definitions for the NEURON PMIP mi commands: */
#define miTYPE		0xF0	// mask
#define miQUEUE		0x0F	// mask

#define miLOCAL_CMD	0x00
#define miTQ		0x02
#define miTQ_P		0x03
#define miNTQ		0x04
#define miNTQ_P		0x05
#define miRESPONSE	0x06
#define miINCOMING	0x08

#define miNULL		0x00
#define miCOMM		0x10
#define miNETMGMT	0x20
#define miTIMEOUT	0x30
#define miCRC		0x40	// not used
#define miRESET		0x50
#define miFLUSH_COMP	0x60	// uplink
#define miFLUSH_CANCEL	0x60	// downlink
#define miONLINE	0x70
#define miOFFLINE	0x80
#define miFLUSH		0x90
#define miFLUSH_IGN	0xA0
#define miSLEEP		0xB0
#define miACK		0xC0
#define miPUPXOFF	0xE1
#define miPUPXON	0xE2

#define MAX_BUFC	90	// limit on buffer counts.

EXT BOOLEAN mip_was_reset;
EXT int io_port_num INIT(PPORT1);

// Parallel I/O functions
void pio_init(void);
int read_isr(void);
int read_hs(void);
BOOLEAN wait_for_hs(void);
byte pio_read(void);
void pio_write(byte pdata);
void reset_mip(void);
